<?php
header('Content-Type: application/json');
include '../database.php';

// Define the target directory for image uploads
$target_dir = "../uploads/images/";
$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];

    // Handle the image upload
    if (isset($_FILES['image'])) {
        $image = $_FILES['image'];
        $target_file = $target_dir . basename($image['name']);
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Check if image file is a valid image
        $check = getimagesize($image['tmp_name']);
        if ($check === false) {
            $response['message'] = 'File is not an image.';
            echo json_encode($response);
            exit();
        }

        // Allow certain file formats
        $allowed_formats = ['jpg', 'jpeg', 'png', 'gif'];
        if (!in_array($imageFileType, $allowed_formats)) {
            $response['message'] = 'Only JPG, JPEG, PNG & GIF files are allowed.';
            echo json_encode($response);
            exit();
        }

        // Move the uploaded file to the target directory
        if (move_uploaded_file($image['tmp_name'], $target_file)) {
            // Insert slider into the database
            $stmt = $conn->prepare("INSERT INTO sliders (name, image) VALUES (?, ?)");
            $stmt->bind_param("ss", $name, $target_file);
            
            if ($stmt->execute()) {
                $response['success'] = true;
                $response['message'] = 'Slider added successfully.';
            } else {
                $response['message'] = 'Failed to add slider to database.';
            }

            $stmt->close();
        } else {
            $response['message'] = 'Failed to upload image.';
        }
    } else {
        $response['message'] = 'No image file uploaded.';
    }
}

$conn->close();
echo json_encode($response);
?>
