<?php
include '../database.php';

header('Content-Type: application/json');

// Hakikisha kuwa kuna user_id imetumwa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id'])) {
    $user_id = $_POST['user_id'];

    // Tafuta subscription ya mtumiaji
    $query = "SELECT id, user_id, subscription_id, start_date, end_date 
              FROM users_subscription 
              WHERE user_id = ? 
              AND NOW() BETWEEN start_date AND end_date 
              LIMIT 1";

    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $subscription = $result->fetch_assoc();
            echo json_encode([
                'success' => true,
                'subscription' => $subscription
            ]);
        } else {
            // Hakuna subscription inayotumika sasa hivi
            echo json_encode([
                'success' => false,
                'message' => 'No active subscription'
            ]);
        }

        $stmt->close();
    } else {
        // Error in preparing the SQL statement
        echo json_encode([
            'success' => false,
            'message' => 'Database error: Failed to prepare statement'
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request or missing user_id'
    ]);
}
?>
