<?php
// delete_category.php

// Include database connection file
include '../database.php'; // Adjust the path if necessary

// Get the JSON data from the request body
$data = json_decode(file_get_contents("php://input"));

// Check if the 'id' property is present
if (isset($data->id)) {
    $categoryId = $data->id;

    // Create a connection to the database
    $conn = new mysqli($servername, $username, $password, $database);

    // Check the connection
    if ($conn->connect_error) {
        die(json_encode(['status' => 'error', 'message' => 'Connection failed: ' . $conn->connect_error]));
    }

    // Prepare the SQL statement to delete the category
    $deleteCategoryQuery = "DELETE FROM categories WHERE id = ?";
    $stmt = $conn->prepare($deleteCategoryQuery);
    
    if ($stmt) {
        // Bind the category ID parameter
        $stmt->bind_param("i", $categoryId);
        
        // Execute the statement
        if ($stmt->execute()) {
            // Check if a row was deleted
            if ($stmt->affected_rows > 0) {
                // Return a success response
                echo json_encode(['status' => 'success', 'message' => 'Category deleted successfully']);
            } else {
                // No category found with that ID
                echo json_encode(['status' => 'error', 'message' => 'No category found with that ID']);
            }
        } else {
            // Return an error response
            echo json_encode(['status' => 'error', 'message' => 'Failed to execute query: ' . $stmt->error]);
        }
        
        // Close the statement
        $stmt->close();
    } else {
        // Return an error response if the statement couldn't be prepared
        echo json_encode(['status' => 'error', 'message' => 'Failed to prepare statement: ' . $conn->error]);
    }

    // Close the database connection
    $conn->close();
} else {
    // Return an error response if 'id' is not provided
    echo json_encode(['status' => 'error', 'message' => 'Category ID not provided']);
}
?>
