<?php
// delete_house.php

// Include database connection file
include '../database.php'; // Adjust the path as necessary

// Get the JSON data from the request body
$data = json_decode(file_get_contents("php://input"));

// Check if the 'id' property is present
if (isset($data->id)) {
    $houseId = $data->id;

    // Begin a transaction
    $conn->begin_transaction();

    try {
        // Delete associated images from the gallery table
        $deleteGalleryQuery = "DELETE FROM gallery WHERE house_id = ?";
        $stmt = $conn->prepare($deleteGalleryQuery);
        $stmt->bind_param("i", $houseId);
        $stmt->execute();

        // Delete the house from the houses table
        $deleteHouseQuery = "DELETE FROM houses WHERE id = ?";
        $stmt = $conn->prepare($deleteHouseQuery);
        $stmt->bind_param("i", $houseId);
        $stmt->execute();

        // Commit the transaction
        $conn->commit();

        // Close the statement
        $stmt->close();

        // Return a success response
        echo json_encode(['status' => 'success', 'message' => 'House deleted successfully']);
    } catch (Exception $e) {
        // Rollback the transaction in case of error
        $conn->rollback();

        // Return an error response
        echo json_encode(['status' => 'error', 'message' => 'Failed to delete house: ' . $e->getMessage()]);
    }
} else {
    // Return an error response if 'id' is not provided
    echo json_encode(['status' => 'error', 'message' => 'House ID not provided']);
}

// Close the database connection
$conn->close();
?>
