<?php
// Include database connection
include '../database.php';

// Set response header to JSON
header('Content-Type: application/json');

// Get the IDs from the request
$idList = isset($_GET['ids']) ? explode(',', $_GET['ids']) : [];

if (empty($idList)) {
    echo json_encode(['success' => false, 'message' => 'No IDs provided.']);
    exit();
}

// Base URL for images
$baseUrl = 'https://panga.blmtec.co.tz/'; // Update this URL as needed

// Prepare the SQL query
$placeholders = implode(',', array_fill(0, count($idList), '?'));
$sql = "SELECT 
            houses.id AS id,
            houses.house_name AS house_name,
            houses.cover_image AS cover_image,
            houses.description AS description,
            houses.price_range AS price_range,
            houses.street AS street,
            houses.owner_contacts AS owner_contacts,
            houses.status AS status,
            categories.name AS category_id,
            mikoa.name AS mkoa_name,
            wilaya.name AS wilaya_name,
            GROUP_CONCAT(gallery.image) AS gallery_images
        FROM 
            houses
        LEFT JOIN 
            categories ON houses.category_id = categories.id
        LEFT JOIN 
            mikoa ON houses.mkoa_id = mikoa.id
        LEFT JOIN 
            wilaya ON houses.wilaya_id = wilaya.id
        LEFT JOIN 
            gallery ON houses.id = gallery.house_id
        WHERE 
            houses.id IN ($placeholders)
        GROUP BY 
            houses.id";

$stmt = $conn->prepare($sql);
$stmt->bind_param(str_repeat('s', count($idList)), ...$idList);
$stmt->execute();
$result = $stmt->get_result();

$houses = [];
while ($row = $result->fetch_assoc()) {
    $houses[] = [
        'id' => $row['id'],
        'house_name' => $row['house_name'],
        'cover_image' => $baseUrl . $row['cover_image'], // Add base URL to cover image
        'description' => $row['description'],
        'price_range' => $row['price_range'],
        'street' => $row['street'],
        'owner_contacts' => $row['owner_contacts'],
        'status' => $row['status'],
        'category_id' => $row['category_id'],
        'mkoa' => $row['mkoa_name'], // Add region
        'wilaya' => $row['wilaya_name'], // Add district
        'gallery' => array_map(fn($image) => $baseUrl . $image, explode(',', $row['gallery_images'])), // Add base URL to gallery images
    ];
}

// Return the houses in JSON format
echo json_encode(['success' => true, 'houses' => $houses]);

// Close the database connection
mysqli_close($conn);
?>
