<?php
header('Content-Type: application/json');

include '../database.php';

$sql = "SELECT h.id, h.house_name, m.name AS mkoa, w.name AS wilaya, h.street, h.owner_contacts 
        FROM houses h 
        JOIN mikoa m ON h.mkoa_id = m.id 
        JOIN wilaya w ON h.wilaya_id = w.id 
        WHERE 1";

$result = $conn->query($sql);

if ($result === false) {
    echo json_encode(['success' => false, 'message' => 'SQL Error: ' . $conn->error]); // Log SQL errors
} else if ($result->num_rows > 0) {
    $houses = array();
    while ($row = $result->fetch_assoc()) {
        $houses[] = array(
            'id' => $row['id'],
            'house_name' => $row['house_name'],
            'location' => $row['mkoa'] . ', ' . $row['wilaya'] . ', ' . $row['street'],
            'owner_contacts' => $row['owner_contacts']
        );
    }
    echo json_encode(['success' => true, 'houses' => $houses]);
} else {
    echo json_encode(['success' => false, 'message' => 'No houses found']);
}

$conn->close();
?>
