<?php
// Include database connection
include '../database.php';

// Set response header to JSON
header('Content-Type: application/json');

// Initialize an empty array to hold house data
$houses = [];

// Base URL for images
$baseUrl = 'https://panga.blmtec.co.tz/'; // Update this URL as needed

// SQL query to fetch houses with location details and gallery images
$sql = "SELECT 
            houses.id AS id,
            houses.house_name AS house_name,
            houses.cover_image AS cover_image,
            houses.description AS description,
            houses.price_range AS price_range,
            houses.street AS street,
            houses.owner_contacts AS owner_contacts,
            houses.status AS status,
            categories.name AS category_id,
            mikoa.name AS mkoa_name,
            wilaya.name AS wilaya_name,
            GROUP_CONCAT(gallery.image) AS gallery_images
        FROM 
            houses
        LEFT JOIN 
            categories ON houses.category_id = categories.id
        LEFT JOIN 
            mikoa ON houses.mkoa_id = mikoa.id
        LEFT JOIN 
            wilaya ON houses.wilaya_id = wilaya.id
        LEFT JOIN 
            gallery ON houses.id = gallery.house_id
        GROUP BY 
            houses.id";

$result = mysqli_query($conn, $sql);

// Check if the query was successful
if ($result) {
    // Fetch the data and store it in the houses array
    while ($row = mysqli_fetch_assoc($result)) {
        $houses[] = [
            'id' => $row['id'],
            'house_name' => $row['house_name'],
            'cover_image' => $baseUrl . $row['cover_image'], // Add base URL to cover image
            'description' => $row['description'],
            'price_range' => $row['price_range'],
            'street' => $row['street'],
            'owner_contacts' => $row['owner_contacts'],
            'status' => $row['status'],
            'category_id' => $row['category_id'],
            'mkoa' => $row['mkoa_name'], // Add region
            'wilaya' => $row['wilaya_name'], // Add district
            'gallery' => array_map(fn($image) => $baseUrl . $image, explode(',', $row['gallery_images'])), // Add base URL to gallery images
        ];
    }
    
    // Return the houses in JSON format
    echo json_encode(['success' => true, 'houses' => $houses]);
} else {
    // Return an error message if the query failed
    echo json_encode(['success' => false, 'message' => 'Failed to retrieve houses.']);
}

// Close the database connection
mysqli_close($conn);
?>
