<?php
header("Content-Type: application/json");
include '../database.php';

$query = "SELECT u.`id`, u.`full_name`, u.`phone`, u.`status`, 
                 s.`name` AS subscription_name, 
                 s.`price`, 
                 us.`end_date`, 
                 CASE 
                     WHEN us.end_date IS NOT NULL AND us.end_date < NOW() THEN 'Expired' 
                     ELSE 'Active' 
                 END AS subscription_status 
          FROM `users` u 
          LEFT JOIN `users_subscription` us ON u.id = us.user_id 
          LEFT JOIN `subscription` s ON us.subscription_id = s.id 
          WHERE us.subscription_id != 1 OR us.subscription_id IS NULL";

$result = mysqli_query($conn, $query);

if ($result) {
    $users = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $row['is_expired'] = ($row['subscription_status'] === 'Expired');
        $users[] = $row;
    }
    echo json_encode(['success' => true, 'users' => $users]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to fetch users']);
}
?>
