<?php
include '../database.php'; // Include your database connection file

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get user ID from the request (make sure to validate it properly)
    if (isset($_GET['user_id'])) {
        $user_id = intval($_GET['user_id']); // Sanitize input

        // Query to fetch user profile
        $query = "SELECT u.id, u.full_name, u.phone, u.status, u.role, us.subscription_id 
                  FROM users u 
                  LEFT JOIN users_subscription us ON u.id = us.user_id 
                  WHERE u.id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            // Fetch subscription name
            $subscription_id = $user['subscription_id'];
            $subscription_query = "SELECT name FROM subscription WHERE id = ?";
            $sub_stmt = $conn->prepare($subscription_query);
            $sub_stmt->bind_param("i", $subscription_id);
            $sub_stmt->execute();
            $sub_result = $sub_stmt->get_result();
            $subscription_name = $sub_result->num_rows > 0 ? $sub_result->fetch_assoc()['name'] : 'No subscription';

            // Prepare response
            $response = [
                'success' => true,
                'profile' => [
                    'id' => $user['id'],
                    'full_name' => $user['full_name'],
                    'phone' => $user['phone'],
                    'status' => $user['status'],
                    'role' => $user['role'],
                    'subscription_name' => $subscription_name,
                ],
            ];
        } else {
            $response = ['success' => false, 'message' => 'User not found'];
        }
    } else {
        $response = ['success' => false, 'message' => 'User ID not provided'];
    }
} else {
    $response = ['success' => false, 'message' => 'Invalid request method'];
}

echo json_encode($response);
?>
