<?php
// Include the database connection file
include '../database.php';

// Initialize an array to hold the response
$response = array();

// Base URL for the images
$baseUrl = 'https://panga.blmtec.co.tz/';

// Prepare the SQL query to fetch sliders
$sql = "SELECT * FROM sliders"; // Adjust this query according to your actual table structure

// Execute the query
$result = mysqli_query($conn, $sql);

// Check if there are results
if (mysqli_num_rows($result) > 0) {
    $response['success'] = true;
    $response['sliders'] = array();

    // Fetch the sliders data
    while ($row = mysqli_fetch_assoc($result)) {
        // Assuming your slider table has 'image' and 'name' columns
        $slider = array(
            'image' => $baseUrl . $row['image'], // Concatenate the base URL with the image path
            'name' => $row['name'],               // Title of the slider
        );
        
        // Add the slider to the response array
        $response['sliders'][] = $slider;
    }
} else {
    $response['success'] = false;
    $response['message'] = 'No sliders found';
}

// Return the JSON response
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
mysqli_close($conn);
?>
