<?php
header('Content-Type: application/json');
include '../database.php';

// Fetch only pending upgrade requests, including user full names, subscription names, and message
$sql = "SELECT ur.id, u.full_name, s.name AS subscription_name, ur.message, ur.status 
        FROM upgrade_requests ur 
        JOIN users u ON ur.user_id = u.id
        JOIN subscription s ON ur.subscription_id = s.id
        WHERE ur.status = 'pending'"; // Filter by pending status
$result = $conn->query($sql);

// Prepare the response
$response = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $response[] = [
            'id' => $row['id'],
            'full_name' => $row['full_name'],
            'subscription_name' => $row['subscription_name'],
            'message' => $row['message'],
            'status' => $row['status'],
        ];
    }
    echo json_encode(['success' => true, 'requests' => $response]);
} else {
    echo json_encode(['success' => true, 'requests' => []]); // No requests found
}

// Close the database connection
$conn->close();
?>
