<?php
include '../database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Total users
    $totalUsersQuery = "SELECT COUNT(*) as total_users FROM users";
    $totalUsersResult = $conn->query($totalUsersQuery);
    $totalUsers = $totalUsersResult->fetch_assoc()['total_users'];

    // Total houses
    $totalHousesQuery = "SELECT COUNT(*) as total_houses FROM houses";
    $totalHousesResult = $conn->query($totalHousesQuery);
    $totalHouses = $totalHousesResult->fetch_assoc()['total_houses'];

    // Paid users (subscription_id not equal to 1)
    $paidUsersQuery = "SELECT COUNT(*) as paid_users FROM users_subscription WHERE subscription_id != 1";
    $paidUsersResult = $conn->query($paidUsersQuery);
    $paidUsers = $paidUsersResult->fetch_assoc()['paid_users'];

    // Pending requests
    $pendingRequestsQuery = "SELECT COUNT(*) as pending_requests FROM upgrade_requests WHERE status = 'pending'";
    $pendingRequestsResult = $conn->query($pendingRequestsQuery);
    $pendingRequests = $pendingRequestsResult->fetch_assoc()['pending_requests'];

    // Return JSON response
    echo json_encode([
        'success' => true,
        'data' => [
            'total_users' => $totalUsers,
            'total_houses' => $totalHouses,
            'paid_users' => $paidUsers,
            'pending_requests' => $pendingRequests,
        ]
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method'
    ]);
} 
?>
