<?php
include '../database.php';

header("Content-Type: application/json");

$response = [
    "success" => false,
    "message" => ""
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = $_POST['phone'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($phone) || empty($password)) {
        $response['message'] = "Phone and password are required.";
        echo json_encode($response);
        exit();
    }

    // Update the query to include the role
    $query = "SELECT id, full_name, phone, password, status, role FROM users WHERE phone = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $full_name, $user_phone, $hashed_password, $status, $role);
        $stmt->fetch();

        if (password_verify($password, $hashed_password)) {
            if ($status === 'active') {
                $response['success'] = true;
                $response['message'] = "Login successful.";
                $response['user'] = [
                    "id" => $id,
                    "full_name" => $full_name,
                    "phone" => $user_phone,
                    "role" => (string)$role // Include role in the response
                ];
            } else {
                $response['message'] = "Account is not active. Please contact support.";
            }
        } else {
            $response['message'] = "Incorrect password.";
        }
    } else {
        $response['message'] = "Phone number not found.";
    }
    $stmt->close();
} else {
    $response['message'] = "Invalid request method.";
}

echo json_encode($response);
?>
