<?php
// post_category.php

include '../database.php'; // Adjust the path as necessary

// Get the JSON data from the request body
$data = json_decode(file_get_contents("php://input"));

// Check if the 'name' property is present
if (isset($data->name)) {
    $categoryName = $data->name;

    // Prepare the SQL statement to insert the new category
    $stmt = $conn->prepare("INSERT INTO categories (name) VALUES (?)");
    $stmt->bind_param("s", $categoryName);

    if ($stmt->execute()) {
        // Return a success response
        echo json_encode(['status' => 'success', 'message' => 'Category added successfully']);
    } else {
        // Return an error response
        echo json_encode(['status' => 'error', 'message' => 'Failed to add category: ' . $stmt->error]);
    }

    // Close the statement
    $stmt->close();
} else {
    // Return an error response if 'name' is not provided
    echo json_encode(['status' => 'error', 'message' => 'Category name not provided']);
}

// Close the database connection
$conn->close();
?>
