<?php
include '../database.php';

header("Content-Type: application/json");

$response = [
    "success" => false,
    "message" => ""
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = $_POST['full_name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $password = $_POST['password'] ?? '';
    $subscription_id = $_POST['subscription_id'] ?? '1'; // Tumia static id kwa sasa
    $start_date = $_POST['start_date'] ?? date('Y-m-d');
    $end_date = $_POST['end_date'] ?? date('Y-m-d', strtotime('+1 year'));

    if (empty($full_name) || empty($phone) || empty($password)) {
        $response['message'] = "All fields are required.";
        echo json_encode($response);
        exit();
    }

    try {
        // Cheki kama namba ya simu tayari imeshasajiliwa
        $checkPhoneQuery = "SELECT id FROM users WHERE phone = ?";
        $stmt = $conn->prepare($checkPhoneQuery);
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $response['message'] = "Phone number already registered.";
            $stmt->close();
            echo json_encode($response);
            exit();
        }
        $stmt->close();

        // Hash ya password
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Ingiza kwenye `users` table
        $userInsertQuery = "INSERT INTO users (full_name, phone, password, status) VALUES (?, ?, ?, 'active')";
        $stmt = $conn->prepare($userInsertQuery);
        $stmt->bind_param("sss", $full_name, $phone, $hashedPassword);

        if ($stmt->execute()) {
            $user_id = $stmt->insert_id;
            $stmt->close();

            // Ingiza kwenye `users_subscription` table
            $subscriptionInsertQuery = "INSERT INTO users_subscription (user_id, subscription_id, start_date, end_date) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($subscriptionInsertQuery);
            $stmt->bind_param("iiss", $user_id, $subscription_id, $start_date, $end_date);

            if ($stmt->execute()) {
                $response['success'] = true;
                $response['message'] = "User registered successfully.";
            } else {
                $response['message'] = "Failed to create subscription record: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $response['message'] = "Failed to register user: " . $stmt->error;
        }
    } catch (Exception $e) {
        $response['message'] = "Server error: " . $e->getMessage();
    }
} else {
    $response['message'] = "Invalid request method.";
}

echo json_encode($response);
?>
