<?php
header('Content-Type: application/json');
include '../database.php';

$request_id = $_POST['request_id'] ?? null;

if (!$request_id) {
    echo json_encode(['success' => false, 'message' => 'Request ID is missing']);
    exit;
}

// Fetch request details
$sql = "SELECT user_id, subscription_id FROM upgrade_requests WHERE id = ? AND status = 'pending'";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $request_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $request = $result->fetch_assoc();
    $user_id = $request['user_id'];
    $subscription_id = $request['subscription_id'];

    // Determine subscription duration
    $start_date = date('Y-m-d H:i:s');
    if ($subscription_id == 2) {
        $end_date = date('Y-m-d H:i:s', strtotime('+24 hours'));
    } elseif ($subscription_id == 3) {
        $end_date = date('Y-m-d H:i:s', strtotime('+1 week'));
    } elseif ($subscription_id == 4) {
        $end_date = date('Y-m-d H:i:s', strtotime('+1 month'));
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid subscription ID']);
        exit;
    }

    // Delete existing subscription if it exists
    $delete_sql = "DELETE FROM users_subscription WHERE user_id = ?";
    $delete_stmt = $conn->prepare($delete_sql);
    $delete_stmt->bind_param('i', $user_id);
    $delete_stmt->execute();

    // Update upgrade request status to 'Paid'
    $update_sql = "UPDATE upgrade_requests SET status = 'Paid' WHERE id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param('i', $request_id);
    $update_stmt->execute();

    // Insert new subscription data
    $insert_sql = "INSERT INTO users_subscription (user_id, subscription_id, start_date, end_date) VALUES (?, ?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_sql);
    $insert_stmt->bind_param('iiss', $user_id, $subscription_id, $start_date, $end_date);
    $insert_stmt->execute();

    echo json_encode(['success' => true, 'message' => 'Request verified successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'No pending request found']);
}

// Close the connection
$conn->close();
?>
